# AI 编程工具大全

> 选择适合你的 AI 编程工具



你好，我是程序员鱼皮，前腾讯全栈开发，全网 200 万粉的 [AI 编程博主](https://space.bilibili.com/12890453)，也是 [AI 导航](https://ai.codefather.cn) 和 [编程导航](https://www.codefather.cn) 等 10+ 自研产品的创造者。

如果你已经完成了【基础必读】的学习，并且成功做出了第一个网页应用，那么恭喜你，已经体验到了 Vibe Coding 的魅力！

但你的心里可能会有这样的疑问：

- 网页 AI 生成器挺好用的，但我听说 Cursor 更强大，到底该用哪个？
- 网上说的 Claude、ChatGPT、Gemini，这些 AI 模型有什么区别？
- 有的工具免费，有的要付费，我应该怎么选择？

别担心，这些困惑都很正常。面对市面上几十上百种 AI 编程工具，就算是专业程序员也会感到眼花缭乱。

这个板块，就是专门为了解决这些问题而设计的。



## 一、为什么要了解编程工具？

在传统编程时代，工具的选择其实没那么重要。无论你用 VS Code 还是 Sublime Text，写出来的代码都是一样的。

但在 Vibe Coding 时代，**选对工具，可能让你的开发效率提升 10 倍！**

为什么这么说？

因为不同的 AI 编程工具：

1. 能力差距很大：有的工具只能生成简单代码，有的能帮你做整个项目
2. 适用场景不同：有的适合做原型，有的适合做产品，有的适合学习
3. 成本差异明显：有的完全免费，有的每月要几百块
4. 学习难度不同：有的上手就能用，有的需要一定基础

选对了工具，你可以事半功倍；选错了工具，可能会让你觉得 “Vibe Coding 也不过如此”。



## 二、AI 编程工具的 3 大类型

在深入了解具体工具之前，我们先来看看 AI 编程工具的基本分类。根据使用方式和复杂度，我把它们分为 3 大类：

![](https://pic.yupi.icu/1/toolstype%E5%A4%A7.jpeg)



### 零代码平台

在浏览器里打开就能用，不需要安装任何软件，不需要懂任何代码。适合完全零基础的新手、想快速做出原型的同学。

代表工具：Bolt.new、Lovable、秒哒

优势：上手快、所见即所得、自动部署

局限：功能相对简单，复杂项目可能力不从心

![](https://pic.yupi.icu/1/image-20260106100544197.png)



### AI 代码编辑器

需要下载安装，界面像传统代码编辑器，但内置了强大的 AI 助手。适合有一定基础、想深入学习 Vibe Coding、需要做复杂项目的人。

代表工具：Cursor、Windsurf、Antigravity、Augment Code

优势：功能强大、灵活度高、适合大型项目

局限：需要一定学习成本，对新手不够友好

![](https://pic.yupi.icu/1/image-20260106100559696.png)



### 命令行工具

在终端里通过命令行和 AI 对话，适合有编程基础的开发者、喜欢命令行的极客。

代表工具：Claude Code、Gemini CLI

优势：效率极高、自动化程度强、成本可控

局限：需要一定技术基础，新手不建议使用

![](https://pic.yupi.icu/1/image-20260106100958506.png)



## 三、这个板块会讲什么？

在这个板块，我会带你全面了解 AI 编程工具的方方面面。

1） AI 模型选择

首先会介绍主流的 AI 模型（Claude、ChatGPT、Gemini 等），帮你理解它们的区别和选择方法。这是使用所有 AI 工具的基础。

2）零代码开发工具

详细讲解各种 AI 零代码平台和 AI 应用开发平台的使用方法，包括快速生成网站的工具、构建 AI 应用的平台、以及能自主执行复杂任务的 AI 智能体平台。

3）专业开发工具

深入介绍 AI 代码编辑器、AI 命令行工具、AI IDE 插件等专业开发工具，帮你找到最适合自己的开发方式。

4）辅助工具集

分享版本管理、部署托管、MCP 服务等实用辅助工具，以及我的工具组合推荐和实战经验。

此外，还会有一些补充文章，深入讲解特定工具的使用方法和测评，供感兴趣的读者参考。



## 四、如何使用这个板块？

这个板块的文章不需要全部学完，你可以根据自己的情况来选择：

根据不同场景和需求，给出具体的工具组合建议。



## 四、如何使用这个板块？

这个板块的文章不需要全部学完，你可以根据自己的情况来选择：

- 如果你是完全新手：建议先看《AI 模型选择指南》，然后重点学习《零代码平台》快速上手。
- 如果你想深入学习：可以直接跳到《AI 代码编辑器》，学习 Cursor 的使用方法。
- 如果你有编程基础：可以看看第《命令行工具》，尝试更高效的开发方式。
- 如果你不知道选什么：直接看《我的工具组合推荐》，我会根据不同场景给你具体建议。
- 如果你想深入了解某个工具：可以阅读相应的补充文章和实战案例。



## 五、学完这个板块，你能收获什么？

通过这个板块的学习，你将能够：

- 理解各类 AI 编程工具的特点和差异
- 根据自己的需求选择合适的工具
- 掌握多个主流工具的使用方法和技巧
- 了解如何搭配使用多个工具提升效率
- 建立自己的工具箱和开发工作流
- 掌握版本管理、项目部署等必备技能

选对工具，真的能让你的开发效率飞起来！🛫



## 写在最后

我知道，面对这么多工具，你可能会觉得有点眼花缭乱。

还记得我在【基础必读】中说过的吗？工具只是手段，重要的是你想做什么。

所以，不要纠结于 “哪个工具最好”，而是要思考 “哪个工具最适合我现在的需求”。

在这个板块中，我会用最接地气的方式，帮你理清这些工具的脉络，让你能够自信地选择和使用它们。

加油，未来的 Vibe Coding 大师！💪



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
